clear all
clc
close all

load AANewData

testalpha=0.05:0.1:1;
r=length(testalpha);
Y=modal';
features=FeaturesAct;
featGame=FeaturesMatrix;

n=length(Y);
%featGame=[featGame gameind];
%DescriptionMatrix=[DescriptionMatrix; 'Part of new games?'];

Row=row;

%% Level-1alpha

alpha=0.41;
lev1=zeros(1,n);
for i=1:n
    R=Row{i}.^alpha;
    sumR=sum(R,2);
    lev1(i)=find(sumR==max(sumR));
end

%% Pareto Dominant Nash

ind=[3,13,23];

FeatParetoDomNE=features(:,ind);

paretonepred=zeros(n,1);
for i=1:n
    if sum(FeatParetoDomNE(i,:))>0
        paretonepred(i)=find(FeatParetoDomNE(i,:));
    else
        paretonepred(i)=randi(3);
    end       
end

%% Train Data

for q=1:20
    
K=10;
c = cvpartition(n,'KFold',K);
for k=1:K
    
    % Training Data
    train=find(c.training(k));
    trainPNE=paretonepred(train);
    trainY=Y(train);
    trainRow=Row(train);
    trainlev1=lev1(train)';
    trainNew=featGame(train,:);
    
    accpne{k}=double(logical(trainPNE==trainY));
    acclev1{k}=double((logical(trainY==trainlev1)));  
    
    treemodelpne{k}=fitrtree(trainNew,accpne{k},'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
    treemodellev1{k}=fitrtree(trainNew,acclev1{k},'MaxNumSplits',2,'PredictorNames',DescriptionMatrix);
 
    % Test Data
    
    test=find(c.test(k));
    testY{k}=Y(test,:);
    testRow=Row(test);
    testNew=featGame(test,:);
    
    pnepredicttest=paretonepred(test);
    testlev1=lev1(test)';
    
    predictpneacc{k}=predict(treemodelpne{k},testNew);
    predictlev1acc{k}=predict(treemodellev1{k},testNew);

    m=length(testY{k});
    for j=1:m
        if predictpneacc{k}(j)>predictlev1acc{k}(j)
            prediction{k}(j)=pnepredicttest(j);
        else
            prediction{k}(j)=testlev1(j);
        end
    end
    error(k)=length(find(prediction{k}'~=testY{k}))/length(prediction{k});  
end

finalacc(q)=1-mean(error);
end

'Accuracy'
mean(finalacc)

'Standard Error'
sqrt(var(error))/sqrt(K)


%% Understanding Model

% How many are assigned to pne vs lev1
for k=1:K
    assignpne(k)=length(find(predictpneacc{k}>predictlev1acc{k}));
    total(k)=length(predictpneacc{k});
end

'Fraction of observations assigned to tree'
mean(assignpne./total)

% Tree used for predicting modal action during cross-validation
%view(treemodelpne{1},'mode','graph')
%view(treemodellev1{1},'mode','graph')

% Evaluate errors on full data
n=length(Y);
for i=1:n
    acclev1ExPost(i)=double(logical(Y(i)==lev1(i)));
    accpneExPost(i)=double(logical(Y(i)==paretonepred(i)));
end

% Tree used for predicting tree error (trained on full data ex post)
predictlev1accExPost=fitrtree(featGame,acclev1ExPost','MaxNumSplits',2,'PredictorNames',DescriptionMatrix)
view(predictlev1accExPost,'mode','graph')

% Tree used for predicting lev1 error (trained on full data ex post)
predictpneaccExPost=fitrtree(featGame,accpneExPost','MaxNumSplits',2,'PredictorNames',DescriptionMatrix)
view(predictpneaccExPost,'mode','graph')
